string GetDescription()
{
	return "Renders the harmony into a track with simple chords";
}

int przew;
int low;
int high;

void SetFirstChord(RenderPart @p, int h)
{
	przew = RndInt(-1,1);
	low = p.GetHarmonicEventPitch(h, przew);
	high = p.GetHarmonicEventPitch(h, przew+p.GetHarmonicComponents(h)-1);
}

int GetDist(RenderPart @p, int harm, int pr)
{
	int l = p.GetHarmonicEventPitch(harm, pr);
	int h = p.GetHarmonicEventPitch(harm, pr+p.GetHarmonicComponents(harm)-1);
	
	int dist = 0;
	
	if (l < low) dist += low-l;
	else dist += l-low;
	
	if (h < high) dist += high-h;
	else dist += h-high;
	
	return dist;
}

void PlaceNextChord(RenderPart @p, Time t1, Time t2)
{
	int harm = 	p.GetHarmonic(t1);
	
	int pr = 0;
	int dist = GetDist(p, harm, pr);

	while (GetDist(p, harm, pr-1) < dist)
	{
		dist = 	GetDist(p, harm, pr-1);
		pr--;
	}
	
	while (GetDist(p, harm, pr+1) <= dist)
	{
		dist = 	GetDist(p, harm, pr+1);
		pr++;
	}
	
	przew = pr;
	low = p.GetHarmonicEventPitch(harm, przew);
	high = p.GetHarmonicEventPitch(harm, przew+p.GetHarmonicComponents(harm)-1);
	
	for (int f = 0; f < p.GetHarmonicComponents(harm); f++)
	{
		p.AddNote(t1, t2, p.GetHarmonicEventPitch(harm, przew+f),RndInt(105,125));	
	}
	
	
}

void Render(RenderPart @p)
{
	SetFirstChord(p,0);
		
	double start = 0;
	
	Time t = CreateTime(p.GetStartBar(), start);
	
	double[] off = { 1.0, 1.5, 1.5 };
		
	double space = 0.5;
	
	double speed = 0.5;
	if (RndInt(0,1) == 0) speed = 1.0;
	
	if (p.GetTempo() > 140) speed = 1.0;
	else if (p.GetTempo() < 70) speed = 0.5;
	
	int start_note = RndInt(0,2);
	
	int note = start_note;
	
	while (t.m_Bar < p.GetEndBar())
	{
		Time t2 = t; 
				
		t.m_Pos += off[note%off.length()]*speed;
		
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Bar++;
			t.m_Pos = start;
			note = start_note;
		}
		else note++;
		
		PlaceNextChord(p,t2,CreateTime(t.m_Bar, t.m_Pos - space*speed));		
		
		
	}
}